# Camera Kit HTTP Request Testing Lens

This lens is designed to test HTTP requests handled by the Camera Kit processor.

## Overview

**User**: The lens was published on behalf of the `camkit-testd` user.

**Lens URL**: In [my-lenses](https://my-lenses.snapchat.com/aed47003-8457-4f0e-805e-acebb78ad7f2/lens-folders/b7b2800a-d1ea-4e67-b2e8-b77f2406ab61/lenses/5e32a908-ba9c-41ed-8d37-eefdcae479b5) and in [BBG](https://beautiful-bubblegum.appspot.com/fil/63887731824).

**Remote API Specification (allowlist)**: This lens requires a Remote API specification for the `camkit-testd` user, which is accessible at: [Remote API Spec](https://my-lenses.snapchat.com/apis/a4e4e7e3-9c4c-42a6-9f5d-99ede01837ff).

## Functionality

The lens includes three buttons, each designed to test different HTTP request scenarios. In all cases, a request is issued using `performHttpRequest` API, and the response object is printed.

### Buttons and Scenarios

1. Trigger good request:

    **Purpose**: Triggers an HTTP request that is allowed by the Remote API spec.

    **Expected Outcome**: The request should succeed without any errors.

2. Trigger validation error:

    **Purpose**: Triggers an HTTP request that is not permitted by the Remote API spec.

    **Expected Outcome**: The request should fail, throwing a validation error on the Camera Kit SDK side.

3. Trigger HTTP error:

    **Purpose**: Triggers an HTTP request that is allowed by the Remote API spec but is expected to receive an HTTP error in response.

    **Expected Outcome**: The request is successfully sent, but the response contains an HTTP error.
